/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class CLIAddressableSizeInfo
extends MIInfo {
    private int fAddressableSize = 1;

    public CLIAddressableSizeInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput) {
                    String line = ((MIConsoleStreamOutput)oob).getString().trim();
                    this.fAddressableSize = this.hexToOctetCount(line);
                }
                ++n2;
            }
        }
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    private int hexToOctetCount(String hexString) {
        int starts = hexString.indexOf("x");
        assert (starts > 0);
        String hexDigits = hexString.substring(starts + 1);
        assert (hexDigits.length() > 1);
        int octets = hexDigits.length() / 2;
        return octets;
    }
}

